﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{


    public class OrdersDetailsDB
    {
        public static OrdersDetails GetItem(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersDetailsID", ((ordersDetailsID != Guid.Empty && ordersDetailsID != null) ? ordersDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveObject<OrdersDetails>("spGetOrdersDetails", parameters);

        }

        public static List<OrdersDetails> GetList(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersDetailsID", ((ordersDetailsID != Guid.Empty && ordersDetailsID != null) ? ordersDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveList<OrdersDetails>("spGetOrdersDetails", parameters);

        }

        public static List<OrdersDetails> GetOfflineList(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersDetailsID", ((ordersDetailsID != Guid.Empty && ordersDetailsID != null) ? ordersDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.RetrieveOfflineList<OrdersDetails>("spGetOrdersDetails", parameters);

        }

        public static DataTable GetDataTable(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersDetailsID", ((ordersDetailsID != Guid.Empty && ordersDetailsID != null) ? ordersDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keywore", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetOrdersDetails", parameters);

        }

        public static DataSet GetDataSet(Guid ordersDetailsID, Guid ordersID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersDetailsID", ((ordersDetailsID != Guid.Empty && ordersDetailsID != null) ? ordersDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetOrdersDetails", parameters);

        }

        public static void Save(OrdersDetails myOrdersDetails)
        {
            myOrdersDetails.Mode = ((myOrdersDetails.UniqueID != Guid.Empty && myOrdersDetails.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myOrdersDetails.UniqueID = ((myOrdersDetails.UniqueID != Guid.Empty && myOrdersDetails.UniqueID != null) ? myOrdersDetails.UniqueID : Guid.NewGuid());
            if (myOrdersDetails.Mode == GlobalConfigurations.Mode.Insert)
            {
                myOrdersDetails.IsActive = true;
                //myOrdersDetails.IsDeleted = false;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();

            parameters.Add(new SqlParameter("@OrdersDetailsID", myOrdersDetails.UniqueID));
            parameters.Add(new SqlParameter("@OrdersID", myOrdersDetails.OrdersID));
            parameters.Add(new SqlParameter("@ProductID", myOrdersDetails.ProductID));
            parameters.Add(new SqlParameter("@ProductName", (string.IsNullOrEmpty(myOrdersDetails.ProductName) ? (object)DBNull.Value : myOrdersDetails.ProductName)));
            parameters.Add(new SqlParameter("@UnitPrice", (myOrdersDetails.UnitPrice == 0 ? (object)DBNull.Value : myOrdersDetails.UnitPrice)));
            parameters.Add(new SqlParameter("@OrderPrice", (myOrdersDetails.OrderPrice == 0 ? (object)DBNull.Value : myOrdersDetails.OrderPrice)));
            parameters.Add(new SqlParameter("@DiscountType", (string.IsNullOrEmpty(myOrdersDetails.DiscountType) ? (object)DBNull.Value : myOrdersDetails.DiscountType)));
            parameters.Add(new SqlParameter("@DiscountValue", (myOrdersDetails.DiscountValue == 0 ? (object)DBNull.Value : myOrdersDetails.DiscountValue)));
            parameters.Add(new SqlParameter("@Quantity", (myOrdersDetails.Quantity == 0 ? (object)DBNull.Value : myOrdersDetails.Quantity)));
            parameters.Add(new SqlParameter("@DiscountQuantity", (myOrdersDetails.DiscountQuantity == 0 ? (object)DBNull.Value : myOrdersDetails.DiscountQuantity)));
            parameters.Add(new SqlParameter("@Amount", (myOrdersDetails.Amount == 0 ? (object)DBNull.Value : myOrdersDetails.Amount)));
            parameters.Add(new SqlParameter("@SpecialInstruction", (string.IsNullOrEmpty(myOrdersDetails.SpecialInstruction) ? (object)DBNull.Value : myOrdersDetails.SpecialInstruction)));
            parameters.Add(new SqlParameter("@CanApplyDiscount", myOrdersDetails.CanApplyDiscount));
            parameters.Add(new SqlParameter("@Remarks", (string.IsNullOrEmpty(myOrdersDetails.Remarks) ? (object)DBNull.Value : myOrdersDetails.Remarks)));
            //parameters.Add(new SqlParameter("@CartonNo", (string.IsNullOrEmpty(myOrdersDetails.CartonNo) ? (object)DBNull.Value : myOrdersDetails.CartonNo)));
            parameters.Add(new SqlParameter("@DONumber", (string.IsNullOrEmpty(myOrdersDetails.DONumber) ? (object)DBNull.Value : myOrdersDetails.DONumber)));
            parameters.Add(new SqlParameter("@DODate", (myOrdersDetails.DODate == DateTime.MinValue ? (object)DBNull.Value : myOrdersDetails.DODate)));
            parameters.Add(new SqlParameter("@OrderStatus", (string.IsNullOrEmpty(myOrdersDetails.OrderStatus) ? (object)DBNull.Value : myOrdersDetails.OrderStatus)));
            parameters.Add(new SqlParameter("@IsMiscellaneous", myOrdersDetails.IsMiscellaneous));
            parameters.Add(new SqlParameter("@SequenceNo", (myOrdersDetails.SequenceNo == 0 ? (object)DBNull.Value : myOrdersDetails.SequenceNo)));
            parameters.Add(new SqlParameter("@CreatedBy", ((myOrdersDetails.UserAccountID != Guid.Empty && myOrdersDetails.UserAccountID != null) ? myOrdersDetails.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myOrdersDetails.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myOrdersDetails.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myOrdersDetails.Mode));

            SQLHelper.ExecuteQuery("spAddOrUpdateOrdersDetails", parameters);

        }

        public static void Delete()
        {
            //if (GlobalConfigurations.AppConfiguration.IsLocalDatabase)
            //{
            string SQL = string.Empty;
            SQL = @"DELETE FROM OrdersDetails";
            SQLHelper.ExecuteQueryStatement(SQL.ToString());
            //}
        }

        public static string GetNewDONumber(Guid ordersID, Guid ordersDetailsID, string invoiceNo)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@OrdersID", ((ordersID != Guid.Empty && ordersID != null) ? ordersID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@OrdersDetailsID", ((ordersDetailsID != Guid.Empty && ordersDetailsID != null) ? ordersDetailsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@InvoiceNo", (string.IsNullOrEmpty(invoiceNo) ? (object)DBNull.Value : invoiceNo)));

            return SQLHelper.ExecuteScalar("spGenerateDOForOrders", parameters).ToString();
        }
    }
}
